/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationExamples;

import java.text.NumberFormat;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Product {

    //These are the properties that EVERY product has.
    private String name;
    private String brand;
    private Description description = new Description();
    private int colour;
    private double price;

    //Constructors
    public Product() {
    }

    public Product(String name) {
        this.name = name;
    }

    public Product(String name, String description, double price) {
        this(name);
        enterDescription(description);
        setPrice(price);
    }

    //Getter and Setter for colour
    public void setColour(String colour) {
        switch (colour) {
            case "Red": 
                this.colour = 0xe6194b;
                break;
            case "Blue":
                this.colour = 0x0082c8;
                break;
            case "Black":
                this.colour = 0x000000;
                break;
            case "Green":
                this.colour = 0x3cb44b;
                break;
            default:
                System.out.println("The products colour must be either Red, Blue, Black or Green");
        }
    }

    public String getColour() {
         switch (this.colour) {
            case 0xe6194b: 
                return "Red";
            case 0x0082c8: 
                return "Blue";
            case 0x000000:
                return "Black";
            case 0x3cb44b: 
                return "Green";
            default:
                return "Internal Error, colour not recognised.";
        }
    }

    public void enterDescription(String comment, String country, int height, int weight) {
        this.description = new Description(comment, country, height, weight);
    }

    public void enterDescription(String comment) {
        this.description = new Description(comment);
    }

    //This method will be used whenever anyone want to print out the details of a product.
    public void printProduct() {
        //Print out Name, Description and Price
        System.out.println("Name: " + getName());
        System.out.println("Description: " + getDescription());
        System.out.println("Price: " + getFormattedPrice());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getDescription() {
        return description.comments
                + " Country: " + description.country
                + " Height: " + description.height
                + " Weight: " + description.weight;
    }

    public String getFormattedPrice() {
        //Define our format as the default currency.
        NumberFormat defaultFormat = NumberFormat.getCurrencyInstance();
        
        //return the price in the default format.
        return defaultFormat.format(price);
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        //Check Security
        if (System.getProperty("role").equals("Admin")) {//check to see if user is admin
            if (price >= 0) {
                this.price = price;
            } else {//Price is negative
                System.out.println("You can not enter a negative price.");
            }
        } else {//Security Failed
            System.out.println("You do not have sufficient privileges to change the price of this product.");
        }
    }
}
